/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.HMCEntityResolver;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class CommonXMLParser
extends DOMParser
implements ErrorHandler {
    private static final String TRACE_MASKT = "XUTLCXPT";
    private static final String TRACE_MASKF = "XUTLCXPF";
    private static final String TRACE_MASKD = "XUTLCXPD";
    public static final String XML_ENTITY_RESOLVER = "XML_ENTITY_RESOLVER";

    public CommonXMLParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        this.setFeature("http://xml.org/sax/features/validation", true);
        this.setErrorHandler(this);
        String entityResolverClass = null;
        try {
            entityResolverClass = System.getProperty(XML_ENTITY_RESOLVER);
        }
        catch (Exception e) {
            entityResolverClass = null;
        }
        if (entityResolverClass != null) {
            try {
                this.setEntityResolver((EntityResolver)Class.forName(entityResolverClass).newInstance());
                return;
            }
            catch (ClassNotFoundException e) {
                Trace.trace(TRACE_MASKF, "ClassNotFoundException attempting to create specified resolver '" + entityResolverClass + "', using default.");
            }
            catch (InstantiationException e) {
                Trace.trace(TRACE_MASKF, "InstantiationException attempting to create specified resolver '" + entityResolverClass + "', using default.");
            }
            catch (IllegalAccessException e) {
                Trace.trace(TRACE_MASKF, "IllegalAccessException attempting to create specified resolver '" + entityResolverClass + "', using default.");
            }
        }
        this.setEntityResolver(new HMCEntityResolver());
    }

    public void warning(SAXParseException saxPE) {
        Trace.trace(TRACE_MASKD, "XML Parsing WARNING: " + CommonXMLParser.where(saxPE));
    }

    public void error(SAXParseException saxPE) throws SAXException {
        Trace.trace(TRACE_MASKD, "XML Parsing ERROR: " + CommonXMLParser.where(saxPE));
        throw saxPE;
    }

    public void fatalError(SAXParseException saxPE) throws SAXException {
        Trace.trace(TRACE_MASKD, "XML Parsing FATAL: " + CommonXMLParser.where(saxPE));
        throw saxPE;
    }

    public static String where(SAXParseException saxPE) {
        return (saxPE.getSystemId() != null ? saxPE.getSystemId() : "") + ":line=" + saxPE.getLineNumber() + ":col=" + saxPE.getColumnNumber() + "  " + saxPE.getMessage();
    }

    public static String gatherTextContents(Node node) throws MalformedXMLException {
        StringBuffer sb = new StringBuffer(128);
        NodeList children = node.getChildNodes();
        int j = 0;
        while (j < children.getLength()) {
            Node child = children.item(j);
            if (child.getNodeType() != 3) {
                throw new MalformedXMLException("Non TEXT_NODE found in inappropriate context.");
            }
            sb.append(child.getNodeValue());
            ++j;
        }
        return sb.toString().trim();
    }

    public static Node getOptionalAttribute(Node node, String attrib) {
        NamedNodeMap nnm = node.getAttributes();
        if (nnm == null) {
            return null;
        }
        Node attribNode = nnm.getNamedItem(attrib);
        if (attribNode == null) {
            return null;
        }
        return attribNode;
    }

    public static Node getRequiredAttribute(Node node, String attrib) throws MalformedXMLException {
        Node attribNode = CommonXMLParser.getOptionalAttribute(node, attrib);
        if (attribNode == null) {
            throw new MalformedXMLException("getRequiredAttribute: Unable to locate REQUIRED '" + attrib + "' attribute on <" + node.getNodeName().toLowerCase() + ">");
        }
        return attribNode;
    }
}

